/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.compras;

import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.ValoresComprobante;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValoresComprobanteReembolso
extends ValoresComprobante {
    private static final long serialVersionUID = -8513489574828181525L;
    public static final String C_BASE_IVA_NO_CERO_REMB = "baseIvaNoCeroReembolso";
    public static final String C_MONTO_IVA_REMB = "montoIvaReembolso";
    public static final String C_BASE_NO_IVA_REMB = "baseNoIvaReemb";
    private static final String BASE_IMPONIBLE_EXCENTA = "baseImponibleExcentaIva";
    @NotNull(message="Debe ingresar el valor de Tarifa IVA diferente de 0%")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Tarifa IVA diferente de 0% debe ser 12 enteros y 2 decimales. ")
    private String baseIvaNoCeroReembolso = "0.00";
    @NotNull(message="Debe ingresar el valor de Monto IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Monto IVA debe ser 12 enteros y 2 decimales. ")
    private String montoIvaReembolso = "0.00";
    @NotNull(message="Debe ingresar el valor de No objeto de IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor No objeto de IVA debe ser 12 enteros y 2 decimales. ")
    private String baseNoIvaReemb = "0.00";
    @NotNull(message="Debe ingresar el valor de Base Imponible Exenta de IVA")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="Debe ingresar el valor de Base Imponible Exenta de IVA")
    private String baseImponibleExcentaIva = "0.00";
    private boolean modificaIva;

    @Override
    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        if (!this.validarMontoIvaReembolso(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        return resultado.esEstadoExitoso() ? resultado.pasarValidacion() : resultado;
    }

    @Override
    public ValoresComprobanteReembolso crearCopiaEdicion() {
        ValoresComprobanteReembolso copia = new ValoresComprobanteReembolso();
        copia.setBaseIvaCero(super.getBaseIvaCero());
        copia.setMontoIce(super.getMontoIce());
        copia.setBaseIvaNoCeroReembolso(this.baseIvaNoCeroReembolso);
        copia.setMontoIvaReembolso(this.montoIvaReembolso);
        copia.setBaseNoIvaReemb(this.baseNoIvaReemb);
        copia.setBaseImponibleExcentaIva(this.baseImponibleExcentaIva);
        copia.setPropietario(this.propietario);
        return copia;
    }

    @Override
    public void actualizarInformacion(ValoresComprobante copiaEdicion) {
        ValoresComprobanteReembolso valoresComprobanteReembolso = (ValoresComprobanteReembolso)copiaEdicion;
        this.setBaseIvaNoCeroReembolso(valoresComprobanteReembolso.getBaseIvaNoCeroReembolso());
        this.setMontoIvaReembolso(valoresComprobanteReembolso.getMontoIvaReembolso());
        this.setBaseNoIvaReemb(valoresComprobanteReembolso.getBaseNoIvaReemb());
        this.setBaseImponibleExcentaIva(valoresComprobanteReembolso.getBaseImponibleExcentaIva());
        super.actualizarInformacion(copiaEdicion);
    }

    protected void validacionAnotadaExitosa() {
        this.sumarBasesImponibles(this.getBaseIvaCero(), this.getBaseIvaNoCeroReembolso(), this.getBaseNoIvaReemb(), this.baseImponibleExcentaIva);
        this.calcularMontoIva();
    }

    protected void calcularMontoIva() {
        this.setMontoIvaCalculado(Util.getPorcentaje(Util.getBigDecimal(this.getBaseIvaNoCeroReembolso()), ((Iva)this.getRaizModelo()).getPorcentajeIva()));
        if (!this.isModificaIva()) {
            this.setMontoIvaReembolso(String.valueOf(this.getMontoIvaCalculado()));
        }
    }

    private ResultadoValidacion validarMontoIvaReembolso(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getMontoIvaReembolso()).compareTo(this.getMontoIvaCalculado()) != 0) {
            return resultado.pasarValidacionAdvertencia("El valor Monto Iva es diferente al valor calculado por el sistema: " + this.getMontoIvaCalculado());
        }
        return resultado;
    }

    @Override
    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("baseImponibleReemb");
        Element eValor = (Element)valorList.item(0);
        this.setBaseIvaCero(eValor.getTextContent().trim());
        valorList = elemento.getElementsByTagName("montoIceRemb");
        eValor = (Element)valorList.item(0);
        this.setMontoIce(eValor.getTextContent().trim());
        valorList = elemento.getElementsByTagName("baseImpGravReemb");
        eValor = (Element)valorList.item(0);
        this.baseIvaNoCeroReembolso = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("baseImpExeReemb");
        eValor = (Element)valorList.item(0);
        this.baseImponibleExcentaIva = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("montoIvaRemb");
        eValor = (Element)valorList.item(0);
        this.montoIvaReembolso = eValor.getTextContent().trim();
        valorList = elemento.getElementsByTagName("baseNoGraIvaReemb");
        eValor = (Element)valorList.item(0);
        this.baseNoIvaReemb = eValor.getTextContent().trim();
        this.sumarBasesImponibles(this.getBaseIvaCero(), this.getBaseIvaNoCeroReembolso(), this.getBaseNoIvaReemb(), this.baseImponibleExcentaIva);
        return this;
    }

    public String getBaseIvaNoCeroReembolso() {
        return this.baseIvaNoCeroReembolso;
    }

    public String getMontoIvaReembolso() {
        return this.montoIvaReembolso;
    }

    public String getBaseNoIvaReemb() {
        return this.baseNoIvaReemb;
    }

    public String getBaseImponibleExcentaIva() {
        return this.baseImponibleExcentaIva;
    }

    public void setBaseImponibleExcentaIva(String baseImponibleExcentaIva) {
        String oldValue = this.baseImponibleExcentaIva;
        this.baseImponibleExcentaIva = baseImponibleExcentaIva;
        this.firePropertyChange(BASE_IMPONIBLE_EXCENTA, oldValue, this.baseImponibleExcentaIva);
    }

    public void setBaseIvaNoCeroReembolso(String baseIvaNoCeroReembolso) {
        String oldValue = this.baseIvaNoCeroReembolso;
        this.baseIvaNoCeroReembolso = baseIvaNoCeroReembolso;
        this.firePropertyChange(C_BASE_IVA_NO_CERO_REMB, oldValue, this.baseIvaNoCeroReembolso);
    }

    public void setMontoIvaReembolso(String montoIvaReembolso) {
        String oldValue = this.montoIvaReembolso;
        this.montoIvaReembolso = montoIvaReembolso;
        this.firePropertyChange(C_MONTO_IVA_REMB, oldValue, this.montoIvaReembolso);
    }

    public void setBaseNoIvaReemb(String baseNoIvaReemb) {
        String oldValue = this.baseNoIvaReemb;
        this.baseNoIvaReemb = baseNoIvaReemb;
        this.firePropertyChange(C_BASE_NO_IVA_REMB, oldValue, this.baseNoIvaReemb);
    }

    public boolean isModificaIva() {
        return this.modificaIva;
    }

    public void setModificaIva(boolean modificaIva) {
        this.modificaIva = modificaIva;
    }
}

